function [ndata] = savpivots_all(data,alldata,ori,termi,ch1,prepost1,fltr3)
%This function is an automated way to extract the pivot list, rotated
%pivot list and pivot properties of a set of classified synapses.  Used to
%be called synpivots
%Synatax:   [ndata] = savpivots(data,ori,termi,idx);
%Input:     data = punc_data data structure used for the classification
%           alldata = all_data data structure from punc_locodist
%           ori = the origin or central pivot used for the analysis
%           termi = the termini for the analysis, really only used for the
%                   generation of the rotated pivots
%           idx = the index of the synaptic subset
%           ch1 = the first third channel, e.g., VGlut1
%           prepost1 = the prepost parameter for punc_colo_all for ch1
%           fltr3 = activate filter 3 in punc_colo_all or not
%Output:    ndata = a structure with the fields, pivots, properties, and
%                   summary.  The layers of the structure match the layer
%                   structure of the data.  Note: filename is carried over
%                   from data.

if nargin==6    %choose default for fltr3
    fltr3 = 1;  %on
end

filenames = data(1).filenames;  %pull out the channel names
pathnames = uigetdir2('','Directory to save the files');       %get the directory where you want to save into.
tverts = data(ori).termi;   %grab the terminal vertices
tprops = data(ori).termi_prop;   %grab the terminal properties
tdist = data(ori).distance;     %grab the distance to termi

%lets generate the classes and the index
%           idx = the index of the synaptic subset
[allidx,idx,adata,neardata] = punc_colo_all(alldata,ori,ch1,'termi',termi,'mod',1,'mod_fltr',1,'pp_fltr',1,'prepost',prepost1,'fltr3',fltr3); %class 1

h = waitbar(0,'Processing Properties of: ');    %initialize progress bar.
count = [];
acount = [];
aucount = [];
for i = 1:size(filenames,2)     %go through the channels
    %initiate
    sdata = [];
    vert_tmp = [];
    prop_tmp = [];
    %process filename
    strmask = isspace(filenames{i});
    spcloc = find(strmask==1);
    filename = strtrim(filenames{i}(min(spcloc):max(spcloc)));
    celllabels{i} = filename;  %create a cell array of file names to label the count files
    waitbar(i/size(filenames,2),h,['Processing Properties of: ' filename]);   %update progress
    if i==ori   %process for data at the origin
        %get self data (self=ori)
        %the nearest index - Note: the ori and the termi is
        %identical for all channels in the neardata and adata structures,
        %so I am just taking the first set.
        vert_tmp = cell2mat(neardata(1).vert);
        prop_tmp = cell2mat(neardata(1).oprop);
        c1 = vert_tmp;           %store this for later use
        %the ori verts are duplicated in the data structure, and I think is
        %unnecessary here, so we are choosing the parsimonenous set.
        avert_tmp = cell2mat(adata(1).vert);
        aprop_tmp = cell2mat(adata(1).oprop);
    elseif i==termi
        vert_tmp = cell2mat(neardata(1).termi);
        prop_tmp = cell2mat(neardata(1).tprop);
        c2 = vert_tmp;           %store this for later use
        %remove duplicates where applicable.
        avert_tmp = cell2mat(adata(1).termi);
        aprop_tmp = cell2mat(adata(1).tprop);
    elseif max(i==ch1)  %the third channel
        curr_chan = find(ch1==i);   %get the location in the data structure where the channel is.
        vert_tmp = cell2mat(neardata(curr_chan).third);
        prop_tmp = cell2mat(neardata(curr_chan).thirdprop);
        avert_tmp = cell2mat(adata(curr_chan).third);
        aprop_tmp = cell2mat(adata(curr_chan).thirdprop);
    else        %not one of the specified channels
        vert_tmp = tverts(:,:,i);    %all ori vertices
        vert_tmp(idx,:) = [];             %all relavent vertices
        vert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
        prop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties + distance
        prop_tmp(idx,:) = [];         %all of the relavent vertices
        prop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
        avert_tmp = tverts(:,:,i);    %all ori vertices
        avert_tmp(allidx,:) = [];             %all relavent vertices
        avert_tmp(isnan(vert_tmp(:,1)),:) = [];  %remove nan lines
        aprop_tmp = [tprops(:,:,i) tdist(:,:,i)];   %all of the ori properties
        aprop_tmp(allidx,:) = [];         %all of the relavent vertices
        aprop_tmp(isnan(prop_tmp(:,1)),:) = [];   %remove nan lines
    end
    %generate the dataset for the count numbers
    count = [count size(vert_tmp,1)];   %get the number of vertices for each channel
    acount = [acount size(avert_tmp,1)];    %do the same for the all data
    aucount = [aucount size(unique(avert_tmp,'rows'),1)];   %get the unique count from all data
    %calculate the summary data
    %no outliers - Note: This calcuation is based on the second row, which
    %in my dataset is the size parameter, but might need to be changed if
    %you want another paramater to be the key one.
    out = median(prop_tmp(:,2))+std(prop_tmp(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(prop_tmp(:,2)>out);        %find the outliers.
    prop_tmp(x,:) = [];             %remove the outliers
    sdata(1,:) = mean(prop_tmp);
    sdata(2,:) = std(prop_tmp);
    sdata(3,:) = size(prop_tmp,1);
    sdata(4,:) = median(prop_tmp);
    %do this for the all property
    %for the property calculation we are going to make this a little more
    %parsimonious using fltr3
    if fltr3
        [cache,fltr3_idx] = unique(avert_tmp,'rows');   %figure out the duplicated vertices
        aprop_tmp = aprop_tmp(fltr3_idx,:);     %unique properties
    end
    out = median(aprop_tmp(:,2))+std(aprop_tmp(:,2))*3;     %3 times the standard deviation should do it.
    [x,y] = find(aprop_tmp(:,2)>out);        %find the outliers.
    aprop_tmp(x,:) = [];             %remove the outliers
    asdata(1,:) = mean(aprop_tmp);
    asdata(2,:) = std(aprop_tmp);
    asdata(3,:) = size(aprop_tmp,1);
    asdata(4,:) = median(aprop_tmp);
    %save the ori data
    sav2csv(vert_tmp,['vert_',filename,'_',num2str(size(vert_tmp,1))],pathnames);    %save the vertices
    sav2csv(prop_tmp,['prop_',filename],pathnames);     %save the properties
    sav2csv(sdata,['sum_',filename],pathnames);     %save the properties
    sav2csv(avert_tmp,['avert_',filename,'_',num2str(size(avert_tmp,1))],pathnames);    %save the vertices
    sav2csv(aprop_tmp,['aprop_',filename],pathnames);     %save the properties
    sav2csv(asdata,['asum_',filename],pathnames);     %save the properties
    %store to ndata
    ndata(i).pivots = vert_tmp;
    ndata(i).props = prop_tmp;
    ndata(i).sum = sdata;
    ndata(i).apivots = avert_tmp;
    ndata(i).aprops = aprop_tmp;
    ndata(i).asum = asdata;
end
%now finish saving the count data
data_tmp = dataset(count','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'count_summary.csv',pathnames);
data_tmp = dataset(acount','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'allcount_summary.csv',pathnames);
data_tmp = dataset(aucount','ObsNames',celllabels','VarNames',{'count'});
sav2csv(data_tmp,'alluniquecount_summary.csv',pathnames);
close(h);   %close progress bar

%now get the rotated vertices
t_out = [];     %initiate
at_out = [];
h1 = waitbar(0,'Rotating Vertices of: ');    %initialize progress bar
%get some information for the all data rotations
ac1 = adata(1).vert;
ac2 = adata(1).termi;
ac_tmp = unique([cell2mat(ac1) cell2mat(ac2)],'rows');  %pick the unique ori termi pairs
ac1 = ac_tmp(:,1:4);   %grab the vertices with ordinals
ac2 = ac_tmp(:,5:7);  %grab the termi vertices
parpool     %lets go massive
for j = 1:size(filenames,2)
    if j~=ori && j~=termi
        %process filename
        strmask = isspace(filenames{j});
        spcloc = find(strmask==1);
        filename = strtrim(filenames{j}(min(spcloc):max(spcloc)));
        waitbar(j/size(filenames,2),h1,['Rotating Vertices of: ' filename]);   %update progress
        c3 = alldata(ori).all_termi(:,:,j);     %get the third point
        [chan,t_tmp] = syn_align_loco(c1,c2,c3);
        [chan1] = flat_verts(chan);
        sav2csv(chan,['3Dvert_',filename],pathnames);
        sav2csv(chan1,['flat_',filename],pathnames);
        t_out = vertcat(t_out,t_tmp);
        %save to ndata
        ndata(j).rotpivots = chan;
        ndata(j).flatpivots = chan1;
        %now process the alldata
        [chan,t_tmp] = syn_align_loco(ac1,ac2,c3);
        [chan1] = flat_verts(chan);
        sav2csv(chan,['a3Dvert_',filename],pathnames);
        sav2csv(chan1,['aflat_',filename],pathnames);
        at_out = vertcat(at_out,t_tmp);
        %save to ndata
        ndata(j).arotpivots = chan;
        ndata(j).aflatpivots = chan1;
    end
end
close(h1);
delete(gcp('nocreate'))

%save terminal output
%[t_out] = rmv_duplicate(t_out,[1 2 3]);     %remove duplicates...does not apply here, but remember collapse!
t_out = unique(t_out,'rows');
ndata(1).termipivots = t_out;
sav2csv(t_out,'rotated_termini',pathnames);
at_out = unique(at_out,'rows');
ndata(1).atermipivots = at_out;
sav2csv(at_out,'arotated_termini',pathnames);
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end
save([pathnames,slash,'ndata.mat'],'ndata');      %save ndata as well

%--------------------------------------------------------------------------
function [chan,t_out,o_out,flprot_idx] = syn_align_loco(ori,termi,third)
%Translate all the points first
o_tmp = zeros(size(ori,1),3); %translate ori to 0,0,0.  This is assuming that all vertices are positive, which for an image should be true.
t_tmp = termi(:,1:3)-ori(:,1:3);    %translate termi

%*********************Randomize the associations***************************
rand_ord = [rand(size(ori,1),1) ori(:,4)];     %create a mashup of ordinal and random ordinals
rand_ord = sortrows(rand_ord);  %shuffle the ordinal order
ori(:,4) = rand_ord(:,2);   %put back into the matrix.

%translate third
parfor j = 1:size(ori,1)
    curr_cell = third{ori(j,4)};    %find the current cell in the third channel.  Use the ordinals to pick the cell
    c_tmp{j,1} = curr_cell(:,1:3)-repmat(ori(j,1:3),size(curr_cell,1),1);       %translate channels
end

%fix one last thing, rotate all negative x's to positive, 180 flip,
%because we are enforcing directionality
flpx_idx = t_tmp(:,1)<0;   %create the flip index: 1 will flip and 0 will not
flpx_mtrx = ones(size(t_tmp,1),1);     %create flip matrix for x
flpx_mtrx(flpx_idx,:) = -1;
%modify termial point
t_tmp(:,1) = t_tmp(:,1).*flpx_mtrx;
t_tmp(:,2) = t_tmp(:,2).*flpx_mtrx;     %y is flipped as well for a 180 turn
%modify channel points (third points)
parfor m = 1:size(c_tmp,1)
    c_tmp{m,1}(:,1) = c_tmp{m,1}(:,1)*flpx_mtrx(m,1);      %rotate 180deg x
    c_tmp{m,1}(:,2) = c_tmp{m,1}(:,2)*flpx_mtrx(m,1);      %rotate 180deg y
end

%Now calculate the angle of rotation on the x axis
%calculate vector 1, ori - termi  rotated
v1 = horzcat(hypot(t_tmp(:,1),t_tmp(:,2)),zeros(size(t_tmp,1),1));   %rotating the syn axis to x 0, everything will be aligned to the y axis
v2 = t_tmp(:,[1 2]);      %the origial 
parfor m = 1:size(v1,1)    %calculate the dot product for each pair of vectors
    x_rot(m,1) = dot(v2(m,:),v1(m,:));     %calculate the dot product, which gives us the cos of the angle
end
%x_rot = acos(x_rot./(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2)))).*180/pi;        %calculate the angles in degress.
x_rot = acosd(single(x_rot)./single(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,2)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
x_rot = x_rot.*neg_idx;         %clockwise and counter clockwise set.
%rotate the base vector
parfor m = 1:size(x_rot,1)
    x_tmp(m,:) = ([cosd(x_rot(m,1)),-sind(x_rot(m,1));sind(x_rot(m,1)),cosd(x_rot(m,1))]*[t_tmp(m,1);t_tmp(m,2)])';
end
t_tmp(:,1) = x_tmp(:,1);
%calculte the angle of roation on the z axis
v3 = horzcat(hypot(t_tmp(:,1),t_tmp(:,3)),zeros(size(t_tmp,1),1));   %rotating the syn axis to z 0
v4 = t_tmp(:,[1 3]);      %the origial vector
parfor n = 1:size(v1,1)        %Dot product per pair of vectors
    z_rot(n,1) = dot(v4(n,:),v3(n,:));     %calculate the dot product, which gives us the cos of the angle
end
%z_rot = acos(z_rot./(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2)))).*180/pi;        %calculate the angles in degress.
z_rot = acosd(single(z_rot)./single(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,3)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
z_rot = z_rot.*neg_idx;         %clockwise and counter clockwise set.

%now rotate the third points
chan = [];      %initialize
%h = waitbar(0,'Rotating Vector: 0');    %initialize progress bar.
parfor k = 1:size(c_tmp,1)
    %waitbar(k/size(c_tmp,1),h,['Rotating Vector: ' num2str(k)]);   %update progress
    curr_cell = c_tmp{k,1};    %find the current cell in the third channel. 
    for l = 1:size(curr_cell,1)     %go through the vertices
        rotx_tmp = [cosd(x_rot(k,1)),-sind(x_rot(k,1));sind(x_rot(k,1)),cosd(x_rot(k,1))]*curr_cell(l,[1 2])';    %rotation in x plane
        rotz_tmp = [cosd(z_rot(k,1)),-sind(z_rot(k,1));sind(z_rot(k,1)),cosd(z_rot(k,1))]*[rotx_tmp(1) curr_cell(l,3)]';    %more acurate for x, but not z???
        chan_tmp(l,:) = [rotz_tmp(1) rotx_tmp(2) rotz_tmp(2)];        %store new rotated vertex.
    end
    chan_tmp(isnan(chan_tmp)) = 0;      %Nan is 0
    chan = vertcat(chan,chan_tmp);      %create the rotated third channel, we no longer need the structure of c_tmp or ori or termi, unbound.
    chan_tmp = [];
end
%close(h);   %close progress bar

%output termi and ori
if size(termi,2)==3     %no extra data, just the vertex
    t_out = [hypot(t_tmp(:,1),hypot(t_tmp(:,2),t_tmp(:,3))),zeros(size(t_tmp,1),2)];
    o_out = o_tmp;
else                    %extra data, concatenate into the matrix
    t_out = horzcat([t_tmp(:,1),zeros(size(t_tmp,1),1),t_tmp(:,3)],termi(:,end-(size(termi,2)-3):end));
    o_out = horzcat(o_tmp,ori(:,end-(size(ori,2)-3):end));
end
%output flprot_idx
flprot_idx = [flpx_idx x_rot z_rot];